#ifndef O_TACHYON_VOLUME_OBJECT_H__
#define O_TACHYON_VOLUME_OBJECT_H__

enum
{
    TACHYON_VOLUME_OBJECT_GROUP_SETTINGS = 1000,
    TACHYON_VOLUME_OBJECT_SETTINGS_HEADER = 1001,
    TACHYON_VOLUME_OBJECT_GROUP_COMMON_PROPS = 1002,
    TACHYON_VOLUME_OBJECT_GROUP_NOISE = 1003,

    TACHYON_VOLUME_OBJECT_VERSION = 1005,

    TACHYON_VOLUME_OBJECT_MODE = 1010,
        TACHYON_VOLUME_OBJECT_MODE_LAYERED = 1,
        TACHYON_VOLUME_OBJECT_MODE_CUBE = 2,

    TACHYON_VOLUME_OBJECT_GROUP_LAYERED = 1100,
    TACHYON_VOLUME_OBJECT_GROUP_CUBE = 1200,

    TACHYON_VOLUME_OBJECT_PRIM_AXIS = 10000, // LONG	   - Direction [0:+X; 1:-X; 2:+Y; 3:-Y; 4:+Z; 5:-Z]
        TACHYON_VOLUME_OBJECT_PRIM_AXIS_XP = 0,
        TACHYON_VOLUME_OBJECT_PRIM_AXIS_XN = 1,
        TACHYON_VOLUME_OBJECT_PRIM_AXIS_YP = 2,
        TACHYON_VOLUME_OBJECT_PRIM_AXIS_YN = 3,
        TACHYON_VOLUME_OBJECT_PRIM_AXIS_ZP = 4,
        TACHYON_VOLUME_OBJECT_PRIM_AXIS_ZN = 5,


    TACHYON_VOLUME_OBJECT_COMMON_DENSITY = 10010,
    TACHYON_VOLUME_OBJECT_COMMON_PHASE = 10015,

    // Noise Tab
    TACHYON_VOLUME_OBJECT_NOISE_ENABLED = 20001,

    TACHYON_VOLUME_OBJECT_NOISE_SPACE = 20003,
        TACHYON_VOLUME_OBJECT_NOISE_SPACE_OBJECT = 0,
        TACHYON_VOLUME_OBJECT_NOISE_SPACE_WORLD = 1,
        TACHYON_VOLUME_OBJECT_NOISE_SPACE_CUSTOM = 2,

    TACHYON_VOLUME_OBJECT_NOISE_ORIGIN_OBJ = 20002,

    TACHYON_VOLUME_OBJECT_NOISE_GRADIENT_ENABLED = 20004,
    TACHYON_VOLUME_OBJECT_NOISE_GRADIENT = 20005,

    TACHYON_VOLUME_OBJECT_NOISE_OCTAVES = 20010,
    TACHYON_VOLUME_OBJECT_NOISE_LACUNARITY = 20015,
    TACHYON_VOLUME_OBJECT_NOISE_PERSISTENCE = 20020,
    TACHYON_VOLUME_OBJECT_NOISE_SCALE = 20025,
    TACHYON_VOLUME_OBJECT_NOISE_ANIM_SPEED = 20030,
    TACHYON_VOLUME_OBJECT_NOISE_TIMEPERIOD = 20035,

    TACHYON_VOLUME_OBJECT_NOISE_ANIM_GROUP = 20043,
    TACHYON_VOLUME_OBJECT_NOISE_ANIM_SPACE = 20041,
    TACHYON_VOLUME_OBJECT_NOISE_ANIM_OBJ = 20042,
    TACHYON_VOLUME_OBJECT_NOISE_MOVEMENT = 20040,
    TACHYON_VOLUME_OBJECT_NOISE_SPEED = 20045,

    TACHYON_VOLUME_OBJECT_NOISE_ADJUSTMENT_GROUP = 20051,
    TACHYON_VOLUME_OBJECT_NOISE_LOW_CLIP = 20050,
    TACHYON_VOLUME_OBJECT_NOISE_HIGH_CLIP = 20055,
    TACHYON_VOLUME_OBJECT_NOISE_BRIGHTNESS = 20060,
    TACHYON_VOLUME_OBJECT_NOISE_CONTRAST = 20065,

    // Mode Param IDs Format: 1_{MODE_IDX}_{SUB_GRP_IDX}_{PARAM_IDX_###}

    // Layered Mode IDs
    TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_BLEND_RANGE = 111001,

    TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_A_GROUP = 112000,
    TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_A_DENSITY = 112001,
    TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_A_PHASE = 112002,
    TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_A_CLIP_ENABLED = 112003,
    TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_A_CLIP_RANGE = 112004,

    TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_B_GROUP = 113000,
    TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_B_DENSITY = 113001,
    TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_B_PHASE = 113002,
    TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_B_CLIP_ENABLED = 113003,
    TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_B_CLIP_RANGE = 113004,

    TACHYON_VOLUME_OBJECT_LAYERED_MEDIA_FLIP_BUTTON = 113100,

    // Cube Mode IDs
    TACHYON_VOLUME_OBJECT_CUBE_SIZE = 121001,
};

#endif
